//	SioSock Class

//	include
#include "stdafx.h"
#include "MtoMSioDefs.h"


/*===================================================*/
//	CSioSock
//	---------------------------------------------------
//		Constructer
/*===================================================*/
/*CSioSock::CSioSock()
{
	m_hCom = INVALID_HANDLE_VALUE ;

	//	COM1,192,8,1,
	m_stConfig.byPort = 1;
	m_stConfig.wBaudrate100 = 192 ;
	m_stConfig.byByteSize = 8 ;
	m_stConfig.byStopBits = STB_1 ;
	m_stConfig.byParity = PTY_EVEN ;
}*/
CSioSock::CSioSock(LPMtoMPortConfig pstSio)
{
	m_hCom = INVALID_HANDLE_VALUE ;

	memcpy( &m_stConfig, pstSio, sizeof(MtoMPortConfig) ) ;
}


/*===================================================*/
//	~CSioSock
//	---------------------------------------------------
//		Destructer
/*===================================================*/
CSioSock::~CSioSock(void)
{
	Close() ;
}


/*===================================================*/
//	Open
//	---------------------------------------------------
//		Open the sio port
/*===================================================*/
bool CSioSock::Open()
{
	char
		strDevice[20] ;
	sprintf( strDevice, _T("\\\\.\\COM%d"), m_stConfig.byPort ) ;
	
	m_hCom = CreateFile(
			strDevice,
			GENERIC_READ | GENERIC_WRITE,	// R/W Mode
			0,				// comm devices must be opened with exclusive-access
			0,				// no security attributes
			OPEN_EXISTING, 	// comm devices must use OPEN_EXISTING
			0,
			0				// hTemplate must be 0 for comm devices
			);

	if (m_hCom == INVALID_HANDLE_VALUE)
	{
		return false;
	}

	// Purge any information in the buffer.
	PurgeComm(m_hCom, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR);
	
	COMMTIMEOUTS
		CommTimeOuts;
	// Setup timeouts
	CommTimeOuts.ReadIntervalTimeout		 = READ_INTERVAL_TIMEOUT ;	
	CommTimeOuts.ReadTotalTimeoutMultiplier  = READ_TOTAL_M ;
	CommTimeOuts.ReadTotalTimeoutConstant	 = READ_TOTAL_C ;
	CommTimeOuts.WriteTotalTimeoutMultiplier = WRITE_TOTAL_M ;
	CommTimeOuts.WriteTotalTimeoutConstant	 = WRITE_TOTAL_C ;
		
	if (!SetCommTimeouts(m_hCom, &CommTimeOuts))
	{
		Close() ;
		return false ;
	}

	// Restore character transmission
	if (!ClearCommBreak(m_hCom))
	{
		Close() ;
		return false ;
	}

	//	configuration
	if( !Config() )
	{
		//	failed -> close
		Close() ;
		return false ;
	}

	return true ;
}


/*===================================================*/
//	Open
//	---------------------------------------------------
//		Open the sio port
/*===================================================*/
bool CSioSock::Open( LPMtoMPortConfig pstComfig )
{
	//	keep the configuration data
	memcpy( &m_stConfig, pstComfig, sizeof(MtoMPortConfig) ) ;
	//	OPEN
	if( !Open() )
	{
		return false ;
	}

	//	config
	if( !Config() )
	{
		//	failed -> close
		Close() ;
		return false ;
	}

	//	OK
	return true ;
}


/*===================================================*/
//	Config
//	---------------------------------------------------
//		Configurate the sio port
/*===================================================*/
bool CSioSock::Config(LPMtoMPortConfig pstSio)
{
	memcpy( &m_stConfig, pstSio, sizeof(MtoMPortConfig) ) ;
	return Config() ;
}


/*===================================================*/
//	Config
//	---------------------------------------------------
//		Configurate the sio port
/*===================================================*/
bool CSioSock::Config()
{
	if( !IsOpen() )
	{
		return false ;
	}
	DCB
		PortDCB;
	// get current configuration
	if (!GetCommState((void*)m_hCom, &PortDCB))
	{
		return false;		// error cannot get device control block
	}

	// set baudrate no error checking
	PortDCB.BaudRate = m_stConfig.wBaudrate100*100;
	PortDCB.ByteSize = m_stConfig.byByteSize;
	switch( m_stConfig.byParity )
	{
	case PTY_NONE:		
		PortDCB.Parity   = NOPARITY;	
		break;
	case PTY_ODD: 		
		PortDCB.Parity   = ODDPARITY;	
		break;
	case PTY_EVEN:		
		PortDCB.Parity   = EVENPARITY;	
		break;
	default:
		return false;		// error
	}

	// set stop bits
	switch(m_stConfig.byStopBits)
	{
	case STB_1:			
		PortDCB.StopBits = ONESTOPBIT;		
		break;
	case STB_1_5:		
		PortDCB.StopBits = ONE5STOPBITS;	
		break;
	case STB_2:			
		PortDCB.StopBits = TWOSTOPBITS;		
		break;
	default:
		return false;		// error
	}

	// set flow control (set default settings (FLW_NONE)
	PortDCB.fBinary					= TRUE;		// This must always be true
    PortDCB.fParity         		= TRUE;		// This must always be true
	PortDCB.fOutX 					= FALSE;
	PortDCB.fInX 					= FALSE;
	PortDCB.fTXContinueOnXoff 		= FALSE;				
	PortDCB.fErrorChar        		= FALSE;				
	PortDCB.fNull             		= FALSE; 				
	PortDCB.EofChar           		= EOFCHAR;
	PortDCB.fAbortOnError     		= FALSE;
	PortDCB.fOutxCtsFlow 			= FALSE;	
	PortDCB.fOutxDsrFlow 			= FALSE;
	PortDCB.fDsrSensitivity 		= FALSE;
	PortDCB.fDtrControl  			= DTR_CONTROL_ENABLE;
	PortDCB.fRtsControl 			= RTS_CONTROL_ENABLE;
	PortDCB.XonChar 				= XON;
	PortDCB.XoffChar 				= XOFF;
	PortDCB.XonLim      			= XON_LIM; 		
	PortDCB.XoffLim     			= XOFF_LIM; 			
//    PortDCB.wReserved         		= 0;

	// Set configuration
	if (!SetCommState((void*)m_hCom, &PortDCB))
	{
		return false;		// error cannot configure device
	}

	COMMTIMEOUTS	Timeouts;			// for setting write timeouts with SetCommTimeouts()
	Timeouts.ReadIntervalTimeout		 = READ_INTERVAL_TIMEOUT ;	
	Timeouts.ReadTotalTimeoutMultiplier  = READ_TOTAL_M ;
	Timeouts.ReadTotalTimeoutConstant	 = READ_TOTAL_C ;
	Timeouts.WriteTotalTimeoutConstant	 = 1000;	// 1000 ms general wait

	switch (m_stConfig.wBaudrate100*100)
	{
	case 300:
		Timeouts.WriteTotalTimeoutMultiplier = 40;
		break;
	case 600:
		Timeouts.WriteTotalTimeoutMultiplier = 20;
		break;
	case 1200:
		Timeouts.WriteTotalTimeoutMultiplier = 10;
		break;
	case 2400:
		Timeouts.WriteTotalTimeoutMultiplier = 5;
		break;
	case 4800:
		Timeouts.WriteTotalTimeoutMultiplier = 3;
		break;
	case 9600:
		Timeouts.WriteTotalTimeoutMultiplier = 2;
		break;
	default:	// 19200 baud and above
		Timeouts.WriteTotalTimeoutMultiplier = 1;
		break;
	}
	if (!SetCommTimeouts((void*)m_hCom, &Timeouts))
	{
		return false;
	}

	return true;
}


/*===================================================*/
//	Close
//	---------------------------------------------------
//		Close the sio port
/*===================================================*/
void CSioSock::Close()
{
	if( m_hCom != INVALID_HANDLE_VALUE )
	{
		CloseHandle(m_hCom);
		m_hCom = INVALID_HANDLE_VALUE ;
	}

	return ;
}


/*===================================================*/
//	Read
//	---------------------------------------------------
//		Read from the sio port
/*===================================================*/
bool CSioSock::Read( LPVOID lpBuffer, DWORD nNumberOfBytesToRead, LPDWORD lpNumberOfBytesRead )
{
	if( !IsOpen() )
	{
		return false ;
	}
	
	OVERLAPPED		Ovl = { 0 };
	if (!ReadFile( m_hCom, lpBuffer, nNumberOfBytesToRead, lpNumberOfBytesRead, &Ovl ))
	{
		DWORD
			dwErrCode = ::GetLastError();
		if ( dwErrCode == ERROR_IO_PENDING  )
		{
			GetOverlappedResult( m_hCom, &Ovl, lpNumberOfBytesRead, TRUE );
		}
		else
		{
			return false ;
		}
	}
	return true ;
}


/*===================================================*/
//	Write
//	---------------------------------------------------
//		Write to the sio port
/*===================================================*/
bool CSioSock::Write( LPVOID lpBuffer, DWORD nNumberOfBytesToWrite, LPDWORD lpNumberOfBytesWrite)
{
	if( !IsOpen() )
	{
		return false ;
	}

	if( !WriteFile( m_hCom, lpBuffer, nNumberOfBytesToWrite, lpNumberOfBytesWrite, NULL ) )
	{
		// Clear device error flag to attempt recovery
		DWORD
			dwError ;
		COMSTAT
			ComStatus;
		ClearCommError( m_hCom, &dwError, &ComStatus );
		return false ;
	}

	return true ;
}


/*===================================================*/
//	IsOpen
//	---------------------------------------------------
//		Check sio state
/*===================================================*/
bool CSioSock::IsOpen(void)
{
	return (m_hCom!=INVALID_HANDLE_VALUE) ? true : false ;
}


/*===================================================*/
//	BufferClear
//	---------------------------------------------------
//		Clear RX and TX buffer
/*===================================================*/
bool CSioSock::BufferClear()
{
	if( !IsOpen() )
	{
		return true ;
	}

	return ((PurgeComm( m_hCom, PURGE_TXCLEAR | PURGE_RXCLEAR ) != 0) ? true : false);
}


